#!/bin/bash
#SBATCH --mem=15G
#SBATCH --cpus-per-task=6
#SBATCH --time=16:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/person/seg_IN1k-%a.out
#SBATCH --partition=gpu
#SBATCH --gres=gpu:1
#SBATCH --exclude=gnodec1,gnodee1
#SBACTH --open-mode=append
#SBATCH --job-name=personseg
#SBATCH --array=0,5,6,7,8,9,10,11,12


echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*100000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*100000))

in_file=_tmp_in1k-noface_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/fast/in1k/person_seg/'
mkdir -p ${results_dir}
< /users/yuki/adiwol/IN1k_train_noface.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

echo "from " ${X}
echo "to " ${Y}

# ETA 4-6Hz
/scratch/shared/beegfs/yuki/envs/pytorch_16/bin/python3 -W ignore deeplabv3.py \
  --img_list=${in_file} \
  --save_folder=${results_dir}